/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.util;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import noppes.npcs.items.crafting.NpcShapedRecipes;

public class NPCRecipeItemHelper
extends RecipeItemHelper {
    public final Int2IntMap field_194124_a = new Int2IntOpenHashMap();

    public void func_194112_a(@Nonnull ItemStack stack) {
        this.accountStack(stack, -1);
    }

    public void accountStack(ItemStack stack, int forceCount) {
        if (!(stack.func_190926_b() || stack.func_77951_h() || stack.func_77948_v() || stack.func_82837_s())) {
            int i = NPCRecipeItemHelper.pack(stack);
            int j = forceCount == -1 ? stack.func_190916_E() : forceCount;
            this.increment(i, j);
        }
    }

    public static int pack(ItemStack stack) {
        Item item = stack.func_77973_b();
        int i = item.func_77614_k() ? stack.func_77960_j() : 0;
        return Item.field_150901_e.func_148757_b((Object)item) << 16 | i & 0xFFFF;
    }

    public boolean func_194120_a(int pos) {
        return this.field_194124_a.get(pos) > 0;
    }

    public int func_194122_a(int countPos, int maximum) {
        int stackPos = this.field_194124_a.get(countPos);
        if (stackPos >= maximum) {
            this.field_194124_a.put(countPos, stackPos - maximum);
            return countPos;
        }
        return 0;
    }

    private void increment(int pathInt, int amount) {
        this.field_194124_a.put(pathInt, this.field_194124_a.get(pathInt) + amount);
    }

    public boolean func_194116_a(@Nonnull IRecipe recipe, @Nullable IntList list) {
        return this.func_194118_a(recipe, list, 1);
    }

    public boolean func_194118_a(@Nonnull IRecipe recipe, @Nullable IntList list, int pos) {
        return new NPCRecipePicker(recipe).tryPick(pos, list);
    }

    public int func_194114_b(@Nonnull IRecipe recipe, @Nullable IntList list) {
        return this.func_194121_a(recipe, Integer.MAX_VALUE, list);
    }

    public int func_194121_a(@Nonnull IRecipe recipe, int pos, @Nullable IntList list) {
        return new NPCRecipePicker(recipe).tryPickAll(pos, list);
    }

    @Nonnull
    public static ItemStack unpack(int pos) {
        return pos == 0 ? ItemStack.field_190927_a : new ItemStack(Item.func_150899_d((int)(pos >> 16 & 0xFFFF)), 1, pos & 0xFFFF);
    }

    public void func_194119_a() {
        this.field_194124_a.clear();
    }

    class NPCRecipePicker {
        private final IRecipe recipe;
        private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
        private final int ingredientCount;
        private final int[] possessedIngredientStacks;
        private final int possessedIngredientStackCount;
        private final BitSet data;
        private final IntList path = new IntArrayList();

        public NPCRecipePicker(IRecipe iRecipe) {
            this.recipe = iRecipe;
            this.ingredients.addAll((Collection<Ingredient>)iRecipe.func_192400_c());
            this.ingredients.removeIf(p_194103_0_ -> p_194103_0_ == Ingredient.field_193370_a);
            this.ingredientCount = this.ingredients.size();
            this.possessedIngredientStacks = this.getUniqueAvailIngredientItems();
            this.possessedIngredientStackCount = this.possessedIngredientStacks.length;
            this.data = new BitSet(this.ingredientCount + this.possessedIngredientStackCount + this.ingredientCount + this.ingredientCount * this.possessedIngredientStackCount);
            for (int i = 0; i < this.ingredients.size(); ++i) {
                IntList intlist = this.ingredients.get(i).func_194139_b();
                for (int j = 0; j < this.possessedIngredientStackCount; ++j) {
                    if (!intlist.contains(this.possessedIngredientStacks[j])) continue;
                    this.data.set(this.getIndex(true, j, i));
                }
            }
        }

        public boolean tryPick(int maximum, @Nullable IntList listIn) {
            boolean flag1;
            if (maximum <= 0) {
                return true;
            }
            int k = 0;
            while (this.dfs(maximum)) {
                NPCRecipeItemHelper.this.func_194122_a(this.possessedIngredientStacks[this.path.getInt(0)], maximum);
                int l = this.path.size() - 1;
                this.setSatisfied(this.path.getInt(l));
                for (int i1 = 0; i1 < l; ++i1) {
                    this.toggleResidual((i1 & 1) == 0, (Integer)this.path.get(i1), (Integer)this.path.get(i1 + 1));
                }
                this.path.clear();
                this.data.clear(0, this.ingredientCount + this.possessedIngredientStackCount);
                ++k;
            }
            boolean flag = k == this.ingredientCount;
            boolean bl = flag1 = flag && listIn != null;
            if (flag1) {
                listIn.clear();
            }
            this.data.clear(0, this.ingredientCount + this.possessedIngredientStackCount + this.ingredientCount);
            int j1 = 0;
            NonNullList list = this.recipe.func_192400_c();
            if (this.recipe instanceof NpcShapedRecipes) {
                Object[] objs = ((NpcShapedRecipes)this.recipe).getGrid();
                list = (NonNullList)objs[2];
            }
            for (Ingredient ingredient : list) {
                if (flag1 && ingredient == Ingredient.field_193370_a) {
                    listIn.add(0);
                    continue;
                }
                for (int l1 = 0; l1 < this.possessedIngredientStackCount; ++l1) {
                    if (!this.hasResidual(false, j1, l1)) continue;
                    this.toggleResidual(true, l1, j1);
                    NPCRecipeItemHelper.this.increment(this.possessedIngredientStacks[l1], maximum);
                    if (!flag1) continue;
                    listIn.add(this.possessedIngredientStacks[l1]);
                }
                ++j1;
            }
            return flag;
        }

        private int[] getUniqueAvailIngredientItems() {
            IntAVLTreeSet intcollection = new IntAVLTreeSet();
            for (Ingredient ingredient : this.ingredients) {
                intcollection.addAll((IntCollection)ingredient.func_194139_b());
            }
            IntIterator intiterator = intcollection.iterator();
            while (intiterator.hasNext()) {
                if (NPCRecipeItemHelper.this.field_194124_a.get(intiterator.nextInt()) > 0) continue;
                intiterator.remove();
            }
            return intcollection.toIntArray();
        }

        private boolean dfs(int minCount) {
            int k = this.possessedIngredientStackCount;
            for (int l = 0; l < k; ++l) {
                if (NPCRecipeItemHelper.this.field_194124_a.get(this.possessedIngredientStacks[l]) < minCount) continue;
                this.visit(false, l);
                while (!this.path.isEmpty()) {
                    int i2;
                    int i1 = this.path.size();
                    boolean notIngredientCount = (i1 & 1) == 1;
                    int j1 = this.path.getInt(i1 - 1);
                    if (!notIngredientCount && !this.isSatisfied(j1)) break;
                    int k1 = notIngredientCount ? this.ingredientCount : k;
                    for (int l1 = 0; l1 < k1; ++l1) {
                        if (this.hasVisited(notIngredientCount, l1) || !this.hasConnection(notIngredientCount, j1, l1) || !this.hasResidual(notIngredientCount, j1, l1)) continue;
                        this.visit(notIngredientCount, l1);
                        break;
                    }
                    if ((i2 = this.path.size()) != i1) continue;
                    this.path.removeInt(i2 - 1);
                }
                if (this.path.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean isSatisfied(int pathInt) {
            return this.data.get(this.getSatisfiedIndex(pathInt));
        }

        private void setSatisfied(int pathInt) {
            this.data.set(this.getSatisfiedIndex(pathInt));
        }

        private int getSatisfiedIndex(int pathInt) {
            return this.ingredientCount + this.possessedIngredientStackCount + pathInt;
        }

        private boolean hasConnection(boolean isNow, int pathNowInt, int pathInt) {
            return this.data.get(this.getIndex(isNow, pathNowInt, pathInt));
        }

        private boolean hasResidual(boolean isNow, int pathNowInt, int pathInt) {
            return isNow != this.data.get(1 + this.getIndex(isNow, pathNowInt, pathInt));
        }

        private void toggleResidual(boolean isNow, int pathNowInt, int pathNextInt) {
            this.data.flip(1 + this.getIndex(isNow, pathNowInt, pathNextInt));
        }

        private int getIndex(boolean isNow, int pathNowInt, int pathNextInt) {
            int k = isNow ? pathNowInt * this.ingredientCount + pathNextInt : pathNextInt * this.ingredientCount + pathNowInt;
            return this.ingredientCount + this.possessedIngredientStackCount + this.ingredientCount + 2 * k;
        }

        private void visit(boolean notIngredientCount, int pathInt) {
            this.data.set(this.getVisitedIndex(notIngredientCount, pathInt));
            this.path.add(pathInt);
        }

        private boolean hasVisited(boolean notIngredientCount, int pathInt) {
            return this.data.get(this.getVisitedIndex(notIngredientCount, pathInt));
        }

        private int getVisitedIndex(boolean notIngredientCount, int pathInt) {
            return (notIngredientCount ? 0 : this.ingredientCount) + pathInt;
        }

        public int tryPickAll(int stackLimitCount, @Nullable IntList list) {
            int i = 0;
            int min = this.getMinIngredientCount(stackLimitCount) + 1;
            while (true) {
                int count;
                if (this.tryPick(count = (i + min) / 2, null)) {
                    if (min - i <= 1) {
                        if (count > 0) {
                            this.tryPick(count, null);
                        }
                        return count;
                    }
                    i = count;
                    continue;
                }
                min = count;
            }
        }

        private int getMinIngredientCount(int stackLimitCount) {
            int count = Integer.MAX_VALUE;
            for (Ingredient ingredient : this.ingredients) {
                int max = stackLimitCount;
                IntList intlist = ingredient.func_194139_b();
                for (int i = 0; i < intlist.size(); ++i) {
                    int maxStack;
                    if (!NPCRecipeItemHelper.this.field_194124_a.containsKey(intlist.get(i))) continue;
                    ItemStack stack = ingredient.func_193365_a()[i];
                    max = Math.max(max, (Integer)NPCRecipeItemHelper.this.field_194124_a.get(intlist.get(i)) / stack.func_190916_E());
                    if (stack.func_77976_d() < stackLimitCount) {
                        max = stackLimitCount = stack.func_77976_d();
                        i = -1;
                        continue;
                    }
                    if (stack.func_190916_E() <= 1 || max <= (maxStack = Math.max(1, (int)Math.floor((double)stack.func_77976_d() / (double)stack.func_190916_E())))) continue;
                    max = maxStack;
                }
                if (count <= 0) continue;
                count = Math.min(count, max);
            }
            return count;
        }
    }
}

